/**********************************************************************************************
* Device      : AD18F08
* Author      : fengxuanmian
* Version     : V0.0.1
* Date        : 2022.3.28
* Description : 配置tmr0 10ms定时(10ms产生一次中断；选择fcpu当计数时钟，使能分频，分频选择256) 每10ms PB1翻转一次
***********************************************************************************************/

#include "AD18F08.h"

/*********************************************中断设置**************************************/
#define           H_SysPri_INIT_EN       0  //使能高优先级中断
#define           H_SysPri_INIT_Dis      1  //禁用高优先级中断
#define           L_SysPri_INIT_EN       2  //使能低优先级中断
#define           L_SysPri_INIT_Dis      3  //禁用低优先级中断

#define           INT_OFF                0  //禁用外设中断
#define           H_Pri_INT              1  //外设使能高优先级中断
#define           L_Pri_INT              2  //外设使能低优先级中断
/*********************************************中断设置**************************************/

/**********************************************TIMER*****************************************/
#define           T0_CLK_EN            1    //使能TIMER0
#define           T0_CLK_DIS           0    //禁用TIMER0

#define           T0_FOSC_2            0    //TIMER0预分频为2
#define           T0_FOSC_4            1    //TIMER0预分频为4
#define           T0_FOSC_8            2    //TIMER0预分频为8
#define           T0_FOSC_16           3    //TIMER0预分频为16
#define           T0_FOSC_32           4    //TIMER0预分频为32
#define           T0_FOSC_64           5    //TIMER0预分频为64
#define           T0_FOSC_128          6    //TIMER0预分频为128
#define           T0_FOSC_256          7    //TIMER0预分频为256

#define           T0_CS_CPU            0    //TIMER0时钟源为CPU 运行时钟
#define           T0_CS_T0CK1          1    //TIMER0时钟源为T0CKI(PA5)
#define           T0_CS_2K             2    //TIMER0时钟源为内部2K
#define           T0_CS_CMPOUT         3    //TIMER0时钟源是CMPOUT输出

#define           T0_EN_NFD            1    //使能TIMER0的时钟且不分频
#define           T0_EN_FD             0    //使能TIMER0的时钟源分频

#define           T0_INT_EN            1    //使能TIMER0中断
#define           T0_INT_DIS           0    //禁止TIMER0中断

#define           T0_SE_U           0    //T0CKI脚上升沿触发计数
#define           T0_SE_D           1    //T0CKI脚下降沿触发计数


/**********************************************TMR0_PWM0*****************************************/

#define              ON               1      //使能PWM输出
#define              OFF              0      //禁止PWM输出

#define              OUT_N            1      //PWM正向输出
#define              OUT_P            0      //PWM反向输出

/**********************************************TMR0_PWM0*****************************************/

/*********************************************************************************************
* 常用配置字功能说明：
*
* _FINTOSC_DIV1     :  内部时钟分频选择
* _DBG_OFF          :  禁用DEBUG模式（使能后DEBUG口不能做普通IO用）
* _LVREN_OFF         :  LVR使能位
* _LVR24V           :  选择LVR电压为2.4V
* _FLASH_CP1_OFF    :  1K~2K*16 FLASH保护位
* _FLASH_CP0_OFF    :  0~1K*16 FLASH保护位
* _IDIS_OFF	     	:  模拟IO打开，数据读取控制位
* _CKSUM_OFF        :  使能程序校验
* _CBP_OFF			:  代码保护选择位
* _RESETE_OFF       :  禁用外部复位
* _RSEL				:  端口上下拉电阻选择
* _STV_ON		    :  堆栈溢出复位使能位
* _PSUT_2		    :  上电复位时间选择位
* _FCPU_4T          :  选择指令周期为4T模式
* _WDTE_OFF         :  看门狗使能位
* _TWDT_000         :  看门狗溢出时间选择位
* _OSCM_HIRC_16M    :  选择内部高速时钟16MHz
* _ADCSP_ON			:  ADC采集速度选择位
* 注意：1.配置字若无特别需求请勿修改；
*       2.其他配置字及相应功能见头文件；
************************************************************************************************/

__CONFIG(1,_FINTOSC_DIV1_1L     & _DBG_OFF_1L       & _LVREN_OFF_1L     & _LVR24V_1L                                                  );
__CONFIG(2,_FLASH_CP1_OFF_2L    & _FLASH_CP0_OFF_2L & _IDIS_OFF_2L     & _CKSUM_OFF_2L  & _CBP_OFF_2L   & _RESETE_OFF_2L & _RSEL_LOW_2L & _STV_ON_2L  );
__CONFIG(3,_PSUT_2_3L           & _FCPU_4T_3L       & _WDTE_OFF_3L    & _TWDT_100_3L                                                );
__CONFIG(4,_OSCM_HIRC_16M_4L    & _MTPDIS_OFF_4L    &_ADCSP_ON_4L                                                                                      );


void Timer0_Timer(unsigned char T0_CS,unsigned char T0_SE,unsigned char CS_EN,unsigned char T0_FD);


//
//         时钟频率/计数分频/指令周期 = 计数频率           (指令周期默认配置字为4T)
//              16M/256/4  =  15.625K
//     一次计数时间:1s/15625 = 0.064ms
//     需要定时10ms  需要计数 10ms/0.064ms = 156.25    故T0周期取156


void main (void)
{
	TRISB1 = 0;      //范例中使用PB1作为输出，由中断控制翻转

    //          时钟源选择CPU(16M)  触发方式（下沿）T0使能分频   256分频
	Timer0_Timer(  T0_CS_CPU,      T0_SE_D,        T0_EN_FD,    T0_FOSC_256);        //只有使用T0CKI作为时钟源时才需要考虑配置触发方式

	TMR0IF = 0;     //清tmr0中断
	TMR0IP = 1;     //设tmr0中断为高优先级
	TMR0IE = 1;     //打开tmr0中断使能

	IPEN = 1;	   //使能中断优先级
	GIEH = 1;      //使能高优先级全局中断
	while(1)
	{

	}
}

//高优先级中断服务函数
void interrupt ISR_h (void)
{
//进入中断后系统自动关闭中断
	if((TMR0IE == 1)&&(TMR0IF == 1))     //tmr0定时10ms产生中断后PB1翻转
	{
		TMR0IF = 0;                      //清除中断标志
		TMR0 = 0;                       //tmr0从0开始计数
		PB1 =~ PB1;
	}
}

//低优先级中断服务函数
void interrupt low_priority ISR_l (void)
{
//当前范例未使用
}


void Timer0_Timer(unsigned char T0_CS,unsigned char T0_SE,unsigned char CS_EN,unsigned char T0_FD)
{

	if (T0_CS == T0_CS_T0CK1)
	{
		TRISA5 = 1;            //PA5设置输入（使用t0cki时配置）
	}
	T0CON = 0X00;
	T0CON |= T0_CS << 5;       //选择计数时钟
	T0CON |= T0_SE << 4;       //选择触发方式（使用t0cki时配置）
	T0CON |= CS_EN << 3;       //tmr0分频使能
	T0CON |= T0_FD;            //tmr0计数时钟分频选择

	PR0 = 156;                 //tmr0计数周期
	TMR0 = 0;                  //设置tmr0初值
	T0CLKEN = 1;               //使能tmr0的时钟
}

